/**
 * Jquery Ajax Pagetransition
 *
 * Copyright 2018 cattlemute (http://www.cattlemute.com)
 *
 * This codes is follow all the rules of jQuery and WordPress.
 */

(function($){
 
	$.fn.Pagetransition = function(options){
		var option = {
			anchor: 'a[href]',
			delay: 0,
		};
		var static = {
			link: 'pagetransition-link',
		};
		var config = $.extend(option, options);
		var inc = $(this), st = null;
 
		var Pagetransition = (function(){
			return{
				init: function(){
					Pagetransition.reverse();
					Pagetransition.clip();
				},
				clip: function(){
					$(config.anchor + ':not([target])').not('#wpadminbar a').addClass(static.link);
					$('.' + static.link).bind('click', function(e){
						e.preventDefault();
						if( $(this).attr('href') !== '' ){
							var post_url = $(this).attr('href');
							Pagetransition.proc(post_url);
						}
					});
				},
				reverse: function(){
					$(window).bind('popstate', function(e) {
						Pagetransition.post(location.href);
					});
				},
				proc: function(post_url){
					history.pushState(null, null, post_url);
					// Closing effect
					st = setTimeout(function(){
						// Opening effect
						Pagetransition.post(post_url);
					}, config.delay);
				},
				post: function(post_url){
					$.ajax({
						type: 'POST',
						url: pagetransition_ajax.url,
						data: {
							action: 'site_pagetranstion',
							url: post_url,
						},
						success: function(result){
							$('html,body').animate({scrollTop: 0}, 0);
							inc.html(result);
							$('.' + static.link).unbind('click');
							Pagetransition.clip();
						},
						error: function(e){
							console.log(e);
						},
					});
				}
			};
		})();
 
		Pagetransition.init();
 
		return(this);
	};
 
})(jQuery);