<?php
/**
 * Class Pagetransition
 *
 * Copyright 2018 cattlemute (http://www.cattlemute.com)
 *
 * @package yourtheme
 * @subpackage yourtheme
 * @since yourtheme
 */

Class Pagetransition {

	private $PagetransitionSettings;

	function __construct() {

		$this->PagetransitionSettings = new PagetransitionSettings();

		add_filter( 'rewrite_rules_array', array( $this, 'rewrite_rules' ) );

		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'wp_head', array( $this, 'load_scripts' ) );

		add_action( 'wp_ajax_site_pagetranstion', array( $this, 'branch_templates' ) );
		add_action( 'wp_ajax_nopriv_site_pagetranstion', array( $this, 'branch_templates' ) );

	}

	public function rewrite_rules( $_rules ) {

		$_add_rules = $this->PagetransitionSettings->rules();
		$_rules = array_merge( $_add_rules, $_rules );

		return $_rules;

	}

	public function enqueue_scripts() {

		wp_enqueue_script( 'js-pagetransition', get_template_directory_uri() . '/lib/pagetransition/jquery.ajax.pagetransition.js', array( 'jquery' ) );

	}

	public function load_scripts() {

		$_params = array(
			'ajax_url' => admin_url( 'admin-ajax.php' ),
		);

		$_scripts = <<<EOT
var pagetransition_ajax = {
	url: '{$_params['ajax_url']}',
};
EOT;

		echo preg_replace( '~\r\n|\r|\n|\t~', '', '<script type="text/javascript">' . $_scripts . '</script>' ) . "\n";

	}

	private function decrypt_queries( $_post_url = '' ) {

		$_entity = '';
		$_matches = array();

		$_rewrite_rules = get_option( 'rewrite_rules' );
		$_host_url = ( empty( $_SERVER['HTTPS'] ) ? 'http://' : 'https://' ) . $_SERVER['HTTP_HOST'];
		$_home_dir = preg_replace( '~' . $_host_url . '~', '', get_home_url() );
		$_request = '' !== $_post_url ? esc_url( $_post_url ) : esc_url( get_home_url() );
		$_request = preg_replace( '~' . $_host_url . '|/$~', '', $_request );

		$_request = str_replace( $_home_dir, '', $_request );

		foreach ( $_rewrite_rules as $_key => $_val ) {

			if ( preg_match( '~' . $_key . '~', $_request, $_matches ) ) {
				$_entity = $_val;
				break;
			}

		}

		if ( ! empty( $_matches ) ) {

			unset( $_matches[0] );

			foreach ( $_matches as $_key => $_val ) {

				$_entity = preg_replace( '~\$matches\[' . $_key . '\]~', $_val, $_entity );

			}

			//$_entity = preg_replace( '~&page=\$matches\[[0-9]{1,}\]~', '', str_replace( '=/', '=', $_entity ) );
			//$_entity = str_replace( 'index.php?', '', preg_replace( '~&page=\$matches\[[0-9]{1,}\]~', '', $_entity ) );
			$_entity = str_replace( 'index.php?', '', $_entity );
			$_entity = preg_replace( '~^\&~', '', $_entity );

			$_entity = preg_replace( '~#.+?$~', '', $_entity );

		}

		return $_entity;

	}

	public function branch_templates() {

		global $wp_rewrite;

		$_url = $_POST['url'];

		$_title = '';

		$_SERVER['REQUEST_URI'] = str_replace( ( empty( $_SERVER['HTTPS'] ) ? 'http://' : 'https://' ) . $_SERVER['HTTP_HOST'], '', $_url );

		$_query_char = $this->decrypt_queries( $_url );

		var_dump($_query_char);

		if ( false === strpos( $_query_char, 'post_type' ) ) {

			$_post_types = $this->PagetransitionSettings->post_types_query();

			foreach ( $_post_types as $_val ) {
				if ( preg_match( '~^' . $_val . '~', $_query_char ) ) {
					$_query_char = $_query_char . '&post_type=' . $_val . '&name=' . str_replace( $_val . '=', '', $_query_char );
					break;
				}
			}

		}

		query_posts( $_query_char );

		$_title = wp_title( '', false );

		if ( '' === $_title ){
			$_title = $this->PagetransitionSettings->pagetransition_after_titles();
			$_title = $_title['home'];
		} else {
			$_title = $this->PagetransitionSettings->pagetransition_after_titles();
			$_title = $_title['every'];
		}

		$_scripts = <<<EOT
(function($){
	var pagetransition_title = '{$_title}';
	document.title = pagetransition_title;
})();
EOT;
		echo preg_replace( '~\r\n|\r|\n|\t~', '', '<script type="text/javascript">' . $_scripts . '</script>' ) . "\n";

		$this->PagetransitionSettings->includes();

		wp_reset_query();

		die();

	}

}

Class PagetransitionCall {

	public function pagenation( $_pagenation = true, $_prev_string = '&lt;', $_next_string = '&gt;' ){

		global $wp_query;

		$_base = $this->replace_pagenation_base();

		$_arguments = array(
			'base'      => $_base,
			'format'    => '?paged=%#%',
			'prev_next' => true,
			'prev_text' => '<span class="prev-string">' . $_prev_string . '</span>',
			'next_text' => '<span class="next-string">' . $_next_string . '</span>',
			'current'   => max( 1, get_query_var('paged') ),
			'type'      => 'plain',
			'total'     => $wp_query->max_num_pages,
		);
		$_pager = paginate_links( $_arguments );

		if ( isset( $_pager ) ) {

			$_pager = preg_replace( '~\t~', '', $_pager );
			$_pager = preg_replace( '~\r\n|\n|\r~', '', $_pager );

			if ( false === $_pagenation ) {
				$_pager = preg_replace( '~<a class=\'page-numbers.+?</a>|<span class="page-numbers.+?</span>|<span aria-current=.+?</span>~', '', $_pager );
				$_pager = preg_replace( '~ page-numbers|page-numbers |page-numbers~', '', $_pager );
				$_pager = '<nav class="pager">' . $_pager . '</nav>';
			} else {
				$_pager = '<nav class="pagenation">' . $_pager . '</nav>';
			}

		}

		echo $_pager;

	}

	private function replace_pagenation_base() {

		$_url = parse_url( ( empty( $_SERVER['HTTPS'] ) ? 'http://' : 'https://' ) . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'], PHP_URL_PATH );

		if ( preg_match ( '~page/~', $_url ) ) {
			$_base = preg_replace( '~page/([0-9]{1,})/~', '', $_url );
			$_base = preg_replace( '~^(.+?)$~', '\1/page/%#%/', $_base );
		} else {
			$_base = preg_replace( '~^(.+?)$~', '\1/page/%#%/', $_url );
		}

		$_base = preg_replace( '~//page/~', '/page/', $_base );

		return $_base;

	}

}