<?php
/**
 * Class Pagetransition
 *
 * Copyright 2018 cattlemute (http://www.cattlemute.com)
 *
 * @package yourtheme
 * @subpackage yourtheme
 * @since yourtheme
 */

Class PagetransitionSettings {

	public function includes() {

		/*
		 * Theme Path Example :
		 * 
		 * your_theme_name
		 * - content (Dir)
		 * - - include-content.php (Template)
		 * - - include-single.php (Template)
		 * - - etc...
		 * - index.php (Template)
		 * - single.php (Template)
		 * - - etc...
		 * 
		 */

		if ( is_page() ) {

			// Page
			get_template_part( 'content/include', 'page' );

		} elseif ( is_attachment() ) {

			// Attachment
			get_template_part( 'content/include', 'attachment' );

		} elseif ( is_singular( 'news' ) ) {

			// Custom post of 'news'
			get_template_part( 'content/include', 'single-news' );

		} elseif ( is_single() ) {

			// Single
			get_template_part( 'content/include', 'single' );

		} elseif ( is_category() ) {

			// Category
			get_template_part( 'content/include', 'content' );

		} elseif ( is_tag() ) {

			// Tags
			get_template_part( 'content/include', 'content' );

		} elseif ( is_tax( 'category_news' ) ) { // Custom taxonomy of 'news'

			get_template_part( 'content/include', 'news' );

		} elseif ( is_date() ) {

			// Date
			get_template_part( 'content/include', 'content' );

		} elseif ( is_search() ) {

			// Search
			get_template_part( 'content/include', 'search' );

		} elseif ( is_author() ) {

			// Author
			get_template_part( 'content/include', 'content' );

		} elseif ( is_post_type_archive( 'news' ) ) {

			// custom post archive of 'news'
			get_template_part( 'content/include', 'news' );

		} elseif ( is_archive() ) {

			// Other archive
			get_template_part( 'content/include', 'content' );

		} else {

			// Front page
			get_template_part( 'content/include', 'frontpage' );

		}

	}

	public function rules() {

		$_rules = array(
			// Search
			'page/([0-9]{1,})/\?s=(.*)$' => 'index.php?paged=$matches[1]&s=$matches[2]',
			'page/([0-9]{1,})/\?s$'      => 'index.php?paged=$matches[1]&s=',
			'\?s=(.*)$' => 'index.php?s=$matches[1]',
			'\?s$'      => 'index.php?s=$matches[1]',
			'search/(.+)/page/?([0-9]{1,})/?$' => 'index.php?s=$matches[1]&amp;paged=$matches[2]',
			'search/(.+)/?$'                   => 'index.php?s=$matches[1]',
			// Date Archives
			'([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$' => 'index.php?year=$matches[1]&amp;monthnum=$matches[2]&amp;day=$matches[3]&amp;paged=$matches[4]',
			'([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$'                   => 'index.php?year=$matches[1]&amp;monthnum=$matches[2]&amp;day=$matches[3]',
			'([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$' => 'index.php?year=$matches[1]&amp;monthnum=$matches[2]&amp;paged=$matches[3]',
			'([0-9]{4})/([0-9]{1,2})/?$'                   => 'index.php?year=$matches[1]&amp;monthnum=$matches[2]',
			'([0-9]{4})/page/?([0-9]{1,})/?$' => 'index.php?year=$matches[1]&amp;paged=$matches[2]',
			'([0-9]{4})/?$'                   => 'index.php?year=$matches[1]',
			// When the static page show the blog 'post' articles.
			'topics/page/([0-9]{1,})/?$' => 'index.php?pagename=topics&paged=$matches[1]',
		);	

		return $_rules;

	}

	public function post_types_query() {

		$_post_types = array(
			// Specify the registered post_type.
			'news',
		);

		return $_post_types;

	}

	public function pagetransition_after_titles() {

		$_titles = array(
			// The title on home and other everything pages.
			'home' => esc_html( get_bloginfo( 'name' ) ) . ' - ' . esc_html( get_bloginfo( 'description' ) ),
			'every' => esc_html( wp_title( '', false ) ) . ' - ' . esc_html( get_bloginfo( 'name' ) ),
		);

		return $_titles;

	}

}