<?php
/**
 * User Functions
 *
 * @package usertheme
 * @subpackage usertheme
 * @since usertheme
 */

require( dirname( __FILE__ ) . '/lib/pagetransition.php' );

function theme_read_scripts() {

	$string = <<<EOT
<script type="text/javascript">
(function($){
	$(document).ready(function(){
		$('Show Blocks example: #contents').Pagetransition({
			anchor: 'HTML A tag example: a[href]',
			delay: 'Show After Delay example: 1000', 
		});
	});
})(jQuery);
</script>
EOT;

	echo preg_replace( '/\r\n|\n|\r|\t/', '', $string );

}
add_action('wp_head', 'theme_read_scripts');





function theme_register_posts() {

	$labels = array(
		"name" => __( "News", "" ),
		"singular_name" => __( "News", "" ),
	);

	$args = array(
		"label" => __( "News", "" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => false,
		"rest_base" => "",
		"has_archive" => true,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "news", "with_front" => true ),
		"query_var" => true,
	);

	register_post_type( "news", $args );

}
add_action( 'init', 'theme_register_posts' );

function theme_register_taxes() {

	$labels = array(
		"name" => __( "Cateogry", "" ),
		"singular_name" => __( "Cateogry", "" ),
	);

	$args = array(
		"label" => __( "Cateogry", "" ),
		"labels" => $labels,
		"public" => true,
		"hierarchical" => true,
		"label" => "Cateogry",
		"show_ui" => true,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"query_var" => true,
		"rewrite" => array( 'slug' => 'category-news', 'with_front' => true, ),
		"show_admin_column" => false,
		"show_in_rest" => false,
		"rest_base" => "category_new",
		"show_in_quick_edit" => false,
	);

	register_taxonomy( "category_new", array( "news" ), $args );

}
add_action( 'init', 'theme_register_taxes' );